/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.findbar.impl;

import com.aptana.editor.findbar.FindBarPlugin;
import com.aptana.editor.findbar.impl.EclipseFindSettings;
import org.eclipse.jface.preference.IPreferenceStore;

public class FindBarConfiguration {
    private final EclipseFindSettings eclipseFindSettings;

    public FindBarConfiguration(EclipseFindSettings eclipseFindSettings) {
        this.eclipseFindSettings = eclipseFindSettings;
    }

    private IPreferenceStore getPreferenceStore() {
        return FindBarPlugin.getDefault().getPreferenceStore();
    }

    public boolean getSearchBackward() {
        return this.getPreferenceStore().getBoolean("com.aptana.editor.findbar.searchBackwardFindBar");
    }

    public boolean getMatchCount() {
        return this.getPreferenceStore().getBoolean("com.aptana.editor.findbar.matchCount");
    }

    public boolean getRegularExpression() {
        return this.getPreferenceStore().getBoolean("com.aptana.editor.findbar.regularExpressionFindBar");
    }

    public boolean getCaseSensitive() {
        return this.getPreferenceStore().getBoolean("com.aptana.editor.findbar.caseSensitiveFindBar");
    }

    public boolean getWholeWord() {
        return this.getPreferenceStore().getBoolean("com.aptana.editor.findbar.wholeWordFindBar");
    }

    public void setCaseSensitive(boolean enable) {
        this.getPreferenceStore().setValue("com.aptana.editor.findbar.caseSensitiveFindBar", enable);
        this.eclipseFindSettings.fCase = enable;
        this.eclipseFindSettings.writeConfiguration();
    }

    public void setWholeWord(boolean enable) {
        this.getPreferenceStore().setValue("com.aptana.editor.findbar.wholeWordFindBar", enable);
        this.eclipseFindSettings.fWholeWord = enable;
        this.eclipseFindSettings.writeConfiguration();
    }

    public void setRegularExpression(boolean enable) {
        this.getPreferenceStore().setValue("com.aptana.editor.findbar.regularExpressionFindBar", enable);
        this.eclipseFindSettings.fRegExSearch = enable;
        this.eclipseFindSettings.writeConfiguration();
    }

    public void setSearchBackward(boolean enable) {
        this.getPreferenceStore().setValue("com.aptana.editor.findbar.searchBackwardFindBar", enable);
    }

    public void setMatchCount(boolean enable) {
        this.getPreferenceStore().setValue("com.aptana.editor.findbar.matchCount", enable);
    }

    public void updateFromEclipseFindSettings() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setValue("com.aptana.editor.findbar.caseSensitiveFindBar", this.eclipseFindSettings.fCase);
        preferenceStore.setValue("com.aptana.editor.findbar.regularExpressionFindBar", this.eclipseFindSettings.fRegExSearch);
        preferenceStore.setValue("com.aptana.editor.findbar.wholeWordFindBar", this.eclipseFindSettings.fWholeWord);
    }

    public void toggle(String preferencesKey) {
        boolean b;
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        boolean bl = b = !preferenceStore.getBoolean(preferencesKey);
        if (preferencesKey.equals("com.aptana.editor.findbar.regularExpressionFindBar")) {
            this.setRegularExpression(b);
        } else if (preferencesKey.equals("com.aptana.editor.findbar.wholeWordFindBar")) {
            this.setWholeWord(b);
        } else if (preferencesKey.equals("com.aptana.editor.findbar.caseSensitiveFindBar")) {
            this.setCaseSensitive(b);
        } else {
            preferenceStore.setValue(preferencesKey, b);
        }
    }
}

